/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.instance.Resample;

public class ResampleTest
extends AbstractFilterTest {
    public ResampleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    @Override
    public Filter getFilter() {
        Resample f = new Resample();
        f.setSampleSizePercent(50.0);
        return f;
    }

    public void testSampleSizePercent() {
        Instances result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ResampleTest.assertEquals("Expecting output to be 50% of input", this.m_Instances.numInstances() / 2, result.numInstances());
        ((Resample)this.m_Filter).setSampleSizePercent(200.0);
        result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ResampleTest.assertEquals("Expecting output to be 200% of input", this.m_Instances.numInstances() * 2, result.numInstances());
    }

    public void testSampleSizePercentNoReplacement() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ResampleTest.assertEquals("Expecting output to be 20% of input", (int)((double)this.m_Instances.numInstances() * 20.0 / 100.0), result.numInstances());
    }

    public void testSampleSizePercentNoReplacementInverted() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        ((Resample)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ResampleTest.assertEquals("Expecting output to be 80% of input (20% inverted)", this.m_Instances.numInstances() - (int)((double)this.m_Instances.numInstances() * 20.0 / 100.0), result.numInstances());
    }

    public void testNoBias() throws Exception {
        this.m_Instances.setClassIndex(1);
        AttributeStats origs = this.m_Instances.attributeStats(1);
        ResampleTest.assertNotNull(origs.nominalCounts);
        Instances result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        ResampleTest.assertNotNull(outs.nominalCounts);
        ResampleTest.assertEquals(origs.nominalCounts.length, outs.nominalCounts.length);
        int i = 0;
        while (i < origs.nominalCounts.length) {
            int est = origs.nominalCounts[i] / 2 - 1;
            ResampleTest.assertTrue("Counts for value:" + i + " orig:" + origs.nominalCounts[i] + " out50%:" + outs.nominalCounts[i], est <= outs.nominalCounts[i] && outs.nominalCounts[i] <= est + 3);
            ++i;
        }
    }

    public void testBiasToUniform() throws Exception {
        this.m_Instances.setClassIndex(1);
        AttributeStats origs = this.m_Instances.attributeStats(1);
        ResampleTest.assertNotNull(origs.nominalCounts);
        ((Resample)this.m_Filter).setBiasToUniformClass(1.0);
        Instances result = this.useFilter();
        ResampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        ResampleTest.assertNotNull(outs.nominalCounts);
        ResampleTest.assertEquals(origs.nominalCounts.length, outs.nominalCounts.length);
        int est = (origs.totalCount - origs.missingCount) / origs.distinctCount;
        est = est / 2 - 1;
        int i = 0;
        while (i < origs.nominalCounts.length) {
            ResampleTest.assertTrue("Counts for value:" + i + " orig:" + origs.nominalCounts[i] + " out50%:" + outs.nominalCounts[i] + " ~wanted:" + est, est <= outs.nominalCounts[i] && outs.nominalCounts[i] <= est + 3);
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(ResampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ResampleTest.suite());
    }
}

